#ifndef __CAN_DL_ERROR_H
#define __CAN_DL_ERROR_H




/////////////////////////////////////////////////////////////////////////////////////
// CAN DL Task
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_CAN_DL_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_CAN_DL_COMMAND_INVALID     ((TLR_RESULT)0xC03F0001L)

//
// MessageId: TLR_E_CAN_DL_CMD_LENGTH_MISMATCH
//
// MessageText:
//
//  The length code of the command is invalid.
//
#define TLR_E_CAN_DL_CMD_LENGTH_MISMATCH ((TLR_RESULT)0xC03F0002L)

//
// MessageId: TLR_E_CAN_DL_UNKNOWN_PARAMETER_TYPE
//
// MessageText:
//
//  The parameter type of the command "Set Paramter" is invalid.
//
#define TLR_E_CAN_DL_UNKNOWN_PARAMETER_TYPE ((TLR_RESULT)0xC03F0003L)

//
// MessageId: TLR_E_CAN_DL_SET_MODE_FAILED
//
// MessageText:
//
//  Within the command "Set Parameter" the function set "CAN Mode" failed.
//
#define TLR_E_CAN_DL_SET_MODE_FAILED     ((TLR_RESULT)0xC03F0004L)

//
// MessageId: TLR_E_CAN_DL_SET_BAUDRATE_FAILED
//
// MessageText:
//
//  Within the command "Set Parameter" the function set "Baudrate" failed.
//
#define TLR_E_CAN_DL_SET_BAUDRATE_FAILED ((TLR_RESULT)0xC03F0005L)

//
// MessageId: TLR_E_CAN_DL_SET_TXABORT_TIME_FAILED
//
// MessageText:
//
//  Within the command "Set Parameter" the function set "Transmission Abort Timer" failed.
//
#define TLR_E_CAN_DL_SET_TXABORT_TIME_FAILED ((TLR_RESULT)0xC03F0006L)

//
// MessageId: TLR_E_CAN_DL_SET_EVENTS_REQUESTED_FAILED
//
// MessageText:
//
//  Within the command "Set Parameter" the function set "Requetsed Events" failed.
//
#define TLR_E_CAN_DL_SET_EVENTS_REQUESTED_FAILED ((TLR_RESULT)0xC03F0007L)

//
// MessageId: TLR_E_CAN_DL_SET_FILTER_FAILED
//
// MessageText:
//
//  Within the command "Set Parameter" or "Set Filter the function set "CAN Filter" failed.
//
#define TLR_E_CAN_DL_SET_FILTER_FAILED   ((TLR_RESULT)0xC03F0008L)

//
// MessageId: TLR_E_CAN_DL_SET_ENABLE_DISABLE_RXID_FAILED
//
// MessageText:
//
//  Within the command Enable or Diasble of receive identifiers an error occurred.
//
#define TLR_E_CAN_DL_SET_ENABLE_DISABLE_RXID_FAILED ((TLR_RESULT)0xC03F0009L)

//
// MessageId: TLR_E_CAN_DL_TX_FRAME_FAILED
//
// MessageText:
//
//  At least one CAN frame could not be send. Normaly because the send process was aborted by the transmission abort timer.
//
#define TLR_E_CAN_DL_TX_FRAME_FAILED     ((TLR_RESULT)0xC03F000AL)

//
// MessageId: TLR_E_CAN_DL_TX_BUFFER_OVERRUN
//
// MessageText:
//
//  The send request of CAN frames was rejected because the internal buffer for send requests is full.
//
#define TLR_E_CAN_DL_TX_BUFFER_OVERRUN   ((TLR_RESULT)0xC03F000BL)

//
// MessageId: TLR_E_CAN_DL_UNKNOWN_DIAG_TYPE
//
// MessageText:
//
//  The diagnostic type of the command "Get Diag" is invalid.
//
#define TLR_E_CAN_DL_UNKNOWN_DIAG_TYPE   ((TLR_RESULT)0xC03F000CL)

//
// MessageId: TRL_E_CAN_DL_TX_ABORT_ALREADY_IN_REQUEST
//
// MessageText:
//
//  The command "Transmission Abort" is already requested.
//
#define TRL_E_CAN_DL_TX_ABORT_ALREADY_IN_REQUEST ((TLR_RESULT)0xC03F000DL)

//
// MessageId: TRL_E_CAN_DL_TX_ABORT
//
// MessageText:
//
//  The send process of can frames was aborted  by "Transmission Abort" command.
//
#define TRL_E_CAN_DL_TX_ABORT            ((TLR_RESULT)0xC03F000EL)

//
// MessageId: TRL_E_CAN_DL_UNKNOWN_APPLICATION
//
// MessageText:
//
//  The application makes access, is not registered at CAN_DL taks.
//
#define TRL_E_CAN_DL_UNKNOWN_APPLICATION            ((TLR_RESULT)0xC03F000FL)

//
// MessageId: TLR_E_CAN_DL_AP_ALREADY_REGISTERED
//
// MessageText:
//
//  The application is already registered.
//
#define TLR_E_CAN_DL_AP_ALREADY_REGISTERED					((TLR_RESULT)0xC03F0010L)

//
// MessageId: TLR_E_CAN_DL_CONF_LOCK_FAIL
//
// MessageText:
//
//  The configuration lock failed.
//
#define TLR_E_CAN_DL_CONF_LOCK_FAIL									((TLR_RESULT)0xC03F0011L)

//
// MessageId: TLR_E_CAN_DL_CONF_LOCKED
//
// MessageText:
//
//  The configuration is locked.
//
#define TLR_E_CAN_DL_CONF_LOCKED										((TLR_RESULT)0xC03F0012L)




#endif  //__CAN_DL_ERROR_H

